<?php
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */
    class Tabella extends GestoreTabella {
        private $tipo;
        
        function construct($id,$classe,$colonne) {
            parent::__construct($id,$classe, $colonne);
        }

        public function aggiungiNuovaRiga($riga, $azioni) {
            $pulsantiAzioni = "<div class=\"btn-group azioni\">";
            foreach($azioni as $tipoPulsante=>$azione) {
                switch($tipoPulsante) {
                    case 'spostaSu':
                        $pulsantiAzioni.=$this->codicePulsanteSpostaSu($azione);
                        break;
                    case 'spostaGiu':
                        $pulsantiAzioni.=$this->codicePulsanteSpostaGiu($azione);
                        break;
                    case 'modifica':
                        $pulsantiAzioni.=$this->codicePulsanteModifica($azione);
                        break;
                    case 'elimina':
                        $pulsantiAzioni.=$this->codicePulsanteElimina($azione);
                        break;
                    case 'visualizza':
                        $pulsantiAzioni.=$this->codicePulsanteVisualizza($azione);
                        break;
                    case 'dettagli':
                        $pulsantiAzioni.=$this->codicePulsanteDettagli($azione);
                        break;
                    case 'attiva':
                        $pulsantiAzioni.=$this->codicePulsanteAttiva($azione);
                        break;
                    case 'sospendi':
                        $pulsantiAzioni.=$this->codicePulsanteSospendi($azione);
                        break;
                    case 'duplica':
                        $pulsantiAzioni.=$this->codicePulsanteDuplica($azione);
                        break;
                    case 'elenco':
                        $pulsantiAzioni.=$this->codicePulsanteElenco($azione);
                        break;
                    case 'scarica':
                        $pulsantiAzioni.=$this->codicePulsanteScarica($azione);
                        break;                    
                    case 'personalizzato':
                        $pulsantiAzioni.=$azione;
                        break;
                }
            }
            $pulsantiAzioni.="</div>";
            $riga[count($riga)] = $pulsantiAzioni; // aggiungo i pulsanti
            parent::aggiungiRiga($riga);
        }
        
        public function codicePulsanteSpostaSu($azione) {
            return "<a class=\"btn visualizza\" href=\"#\" onclick=\"$azione\"  data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\"><i class=\"fas fa-arrow-up\"></i> </a>";
        }
        
        public function codicePulsanteSpostaGiu($azione) {
            return "<a class=\"btn visualizza\" href=\"#\" onclick=\"$azione\"  data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giù\"><i class=\"fas fa-arrow-down\"></i> </a>";
        }
        
        public function codicePulsanteDettagli($azione) {
            return "<a class=\"btn visualizza\" href=\"$azione\"  data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Dettagli\"><i class=\"fas fa-search\"></i> </a>";
        }
        
        public function codicePulsanteVisualizza($azione) {
            return "<a class=\"btn visualizza\" href=\"$azione\"  data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Visualizza\"><i class=\"fas fa-external-link-alt\"></i> </a>";
        }
        
        public function codicePulsanteModifica($azione) {
            return "<a class=\"btn modifica\" href=\"$azione\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\"><i class=\"far fa-edit\"></i> </a>";
        }

        public function codicePulsanteElimina($azione) {
            return "<a  class=\"btn elimina\" href=\"javascript:void\" onclick=\"{$azione}\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\"><i class=\"far fa-trash-alt\"></i> </a>";
        }
        
        public function codicePulsanteSospendi($azione) {
            return "<a  class=\"btn modifica\" href=\"#\" onclick=\"{$azione}\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"\" data-original-title=\"Sospendi\" ><span class=\"fas fa-ban\"></span></a>";
        }
        
        public function codicePulsanteAttiva($azione) {
            return "<a class=\"btn modifica\" href=\"#\" onclick=\"{$azione}\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Riattiva\" data-original-title=\"Attiva\"><span class=\"far fa-check-circle\"></span></button>";
        }
        
        public function codicePulsanteDuplica($azione) {
            return"<a class=\"btn duplica\" href=\"$azione\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Duplica\"><i class=\"far fa-clone\"></i> </a>";
        }
        
        /*
         * Crea un pulsante con un'icona di un elenco
         * NB: è necessario che questo elemento sia un array, deve contenere il link e il titolo del tooltip
         */
        public function codicePulsanteElenco($azione) {
            return"<a class=\"btn duplica\" href=\"{$azione[0]}\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"{$azione[1]}\"><i class=\"fas fa-list\"></i> </a>";
        }

        public function codicePulsanteScarica($azione) {
            return"<a class=\"btn modifica\" href=\"$azione\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Scarica\"><i class=\"fas fa-download\"></i> </a>";
        }
        
        
        function getTipo() {
            return $this->tipo;
        }

        function setTipo($tipo) {
            $this->tipo = $tipo;
        }
    }